% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PKNCA.R
\name{PKNCA_impute_method_start_logslope}
\alias{PKNCA_impute_method_start_logslope}
\title{This function imputes the start concentration using the log slope method.}
\usage{
PKNCA_impute_method_start_logslope(
  conc,
  time,
  start,
  end,
  ...,
  options = list()
)
}
\arguments{
\item{conc}{Numeric vector of concentrations.}

\item{time}{Numeric vector of times corresponding to the concentrations.}

\item{start}{Numeric value indicating the start/dose time.}

\item{end}{Numeric value indicating the end time.}

\item{...}{Additional arguments (currently not used).}

\item{options}{List of options (currently not used).}
}
\value{
A data frame with imputed start concentration.
}
\description{
This function imputes the start concentration using the log slope method.
}
\details{
This function adheres to the structure required by the \code{PKNCA} package to work with its
functionalities. For more information, see the
\href{https://CRAN.R-project.org/package=PKNCA}{PKNCA Data Imputation Vignette}.
}
\examples{
conc <- c(5, 4, 3, 2, 1)
time <- c(1, 2, 3, 4, 5)
start <- 0
end <- 4
PKNCA_impute_method_start_logslope(conc, time, start, end)
}
