% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta.R
\name{chebyshev}
\alias{chebyshev}
\title{Chebyshev distance}
\usage{
chebyshev(x, y)
}
\arguments{
\item{x, y}{Numeric vectors}
}
\value{
The Chebyshev distance between \code{x} and \code{y}.
}
\description{
The Chebyshev distance is the maximum absolute difference between the vector
elements.
}
\details{
For vectors \code{x} and \code{y}, the Chebyshev distance is defined as
\deqn{d(x, y) = \max_i |x_i - y_i|.} Relation to other definitions:
\itemize{
  \item Equivalent to the \code{chebyshev()} function in
    \code{scipy.spatial.distance}.
}
}
\examples{
x <- c(15, 6, 4, 0, 3, 0)
y <- c(10, 2, 0, 1, 1, 0)
chebyshev(x, y) # should be 5
}
