% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accrual_plots.r, R/gg_accrual_plots.R
\name{accrual_plot_abs}
\alias{accrual_plot_abs}
\alias{gg_accrual_plot_abs}
\title{Absolute accrual plots}
\usage{
accrual_plot_abs(
  accrual_df,
  unit = c("month", "year", "week", "day"),
  target = NULL,
  overall = TRUE,
  name_overall = attr(accrual_df, "name_overall"),
  ylim = NULL,
  xlim = NULL,
  ylab = "Recruited patients",
  xlabformat = NULL,
  xlabsel = NA,
  xlabpos = NULL,
  xlabsrt = 45,
  xlabadj = c(1, 1),
  xlabcex = 1,
  col = NULL,
  legend.list = NULL,
  ...
)

gg_accrual_plot_abs(
  accrual_df,
  unit = c("month", "year", "week", "day"),
  xlabformat = NULL
)
}
\arguments{
\item{accrual_df}{object of class 'accrual_df' or 'accrual_list' produced by \code{accrual_create_df}.}

\item{unit}{time unit for which the bars should be plotted,
one of \code{"month"}, \code{"year"}, \code{"week"} or \code{"day"}.}

\item{target}{adds horizontal line for target recruitment per time unit.}

\item{overall}{logical, indicates that accrual_df contains a summary with all sites
that should be removed from stacked barplot (only if by is not NA).}

\item{name_overall}{name of the summary with all sites (if by is not NA and overall==TRUE).}

\item{ylim}{limits for y-axis.}

\item{xlim}{limits for x-axis.}

\item{ylab}{y-axis label.}

\item{xlabformat}{format of date on x-axis.}

\item{xlabsel}{selection of x-labels if not all should be shown,
by default all are shown up to 15 bars, with more an automated selection is done,
either NA (default), NULL (show all), or a numeric vector.}

\item{xlabpos}{position of the x-label.}

\item{xlabsrt}{rotation of x-axis labels in degrees.}

\item{xlabadj}{adjustment of x-label, numeric vector with length 1 or 2 for different adjustment
in x- and y-direction.}

\item{xlabcex}{size of x-axis label.}

\item{col}{colors of bars in barplot, can be a vector if accrual_df is a list, default is grayscale.}

\item{legend.list}{named list with options passed to legend().}

\item{...}{further arguments passed to barplot() and axis().}
}
\value{
\code{accrual_plot_abs} returns a barplot of absolute accrual by time unit (stacked if accrual_df is a list).


}
\description{
Plot of absolute recruitment by time unit using an accrual data frame produced by \code{accrual_create_df}.
}
\details{
When the \code{accrual_df} includes multiple sites, the dataframe
passed to \code{ggplot} includes a \code{site} variable
which can be used for facetting
}
\examples{
set.seed(2020)
enrollment_dates <- as.Date("2018-01-01") + sort(sample(1:100, 50, replace=TRUE))
accrual_df<-accrual_create_df(enrollment_dates)
accrual_plot_abs(accrual_df,unit="week")

#time unit
accrual_plot_abs(accrual_df,unit="day")

#include target
accrual_plot_abs(accrual_df,unit="week",target=5)

#further plot options
accrual_plot_abs(accrual_df,unit="week",ylab="No of recruited patients",
   xlabformat="\%Y-\%m-\%d",xlabsrt=30,xlabpos=-0.8,xlabadj=c(1,0.5),
   col="pink",tck=-0.03,mgp=c(3,1.2,0))

#accrual_df with by option
set.seed(2020)
centers<-sample(c("Site 1","Site 2","Site 3"),length(enrollment_dates),replace=TRUE)
centers<-factor(centers,levels=c("Site 1","Site 2","Site 3"))
accrual_df<-accrual_create_df(enrollment_dates,by=centers)
accrual_plot_abs(accrual_df=accrual_df,unit=c("week"))

### ggplot2 approach
data(accrualdemo)
accrual_df<-accrual_create_df(accrualdemo$date)
gg_accrual_plot_abs(accrual_df, unit = "week")
gg_accrual_plot_abs(accrual_df, unit = "week") +
  ggplot2::theme_classic()

#time unit
gg_accrual_plot_abs(accrual_df, unit = "day")

#accrual_df with by option
accrual_df <- accrual_create_df(accrualdemo$date, by = accrualdemo$site)
gg_accrual_plot_abs(accrual_df = accrual_df, unit = "week")
gg_accrual_plot_abs(accrual_df = accrual_df, unit = "week") +
  ggplot2::scale_fill_discrete(type = c("black", "red", "blue", "green"))

}
