% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aclhs.R
\name{aclhs.get_correlations}
\alias{aclhs.get_correlations}
\title{Computes correlations between the original and aclhs-sampled data.}
\usage{
aclhs.get_correlations(df, aclhs_samples)
}
\arguments{
\item{df}{The original data in dataframe format}

\item{aclhs_samples}{The acLHS-derived sample indices}
}
\value{
A dataframe with the original and aclhs-sampled correlation values
}
\description{
Computes the Pearson, Spearman, and Kendall correlations of the independent
and dependent variable of the original and aclhs-sampled data. Correlation
values are rounded to the third decimal place.
}
\examples{
## Get the data of interest and get the acLHS sample indices
data(ex_data_2D)
input2D <- ex_data_2D
aclhs_sam <- aclhs(df=input2D, num_samples=50, weights=c(1,1,1), iter=100)

## Compute the correlations
correlations <- aclhs.get_correlations(df=input2D, aclhs_samples=aclhs_sam)
}
