% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residency.R
\name{residency}
\alias{residency}
\title{Residency Analysis}
\usage{
residency(
  tz = NULL,
  section.order = NULL,
  datapack = NULL,
  max.interval = 60,
  minimum.detections,
  min.total.detections = 2,
  min.per.event = 1,
  start.time = NULL,
  stop.time = NULL,
  speed.method = c("last to first", "last to last"),
  speed.warning = NULL,
  speed.error = NULL,
  jump.warning = 2,
  jump.error = 3,
  inactive.warning = NULL,
  inactive.error = NULL,
  exclude.tags = NULL,
  override = NULL,
  report = FALSE,
  auto.open = TRUE,
  discard.orphans = FALSE,
  discard.first = NULL,
  save.detections = FALSE,
  section.warning = 1,
  section.error = 1,
  section.minimum,
  timestep = c("days", "hours"),
  replicates = NULL,
  GUI = c("needed", "always", "never"),
  save.tables.locally = FALSE,
  print.releases = TRUE,
  detections.y.axis = c("auto", "stations", "arrays")
)
}
\arguments{
\item{tz}{The time zone of the study area. Must match one of the values
present in \code{\link[base]{timezones}}.}

\item{section.order}{A vector containing the order by which sections should
be aligned in the results.}

\item{datapack}{A data bundle pre-compiled through the function \code{\link{preload}}.
May be used to run actel analyses based on R objects, rather than input files.}

\item{max.interval}{The number of minutes that must pass between detections
for a new event to be created. Defaults to 60.}

\item{minimum.detections}{DEPRECATED. Please use the arguments min.total.detections
and min.per.event instead.}

\item{min.total.detections}{Minimum number of times a tag must have
been detected during the study period for the detections to be considered true
and not just random noise. Defaults to 2.}

\item{min.per.event}{Minimum number of detections an event must have to be
deemed valid. For analyses with both array and section events, a vector of
two values can be provided. If only one value is provided, the same threshold
applies for both types of events. Defaults to 1.}

\item{start.time}{Detection data prior to the timestamp set in
\code{start.time} (in YYYY-MM-DD HH:MM:SS format) is not considered during
the analysis.}

\item{stop.time}{Detection data posterior to the timestamp set in
\code{stop.time} (in YYYY-MM-DD HH:MM:SS format) is not considered during
the analysis.}

\item{speed.method}{Can take two forms: 'last to first' or 'last to last'.
If 'last to first' (default), the last detection on the previous array is matched
to the first detection on the target array to perform the calculations.
If 'last to last', the last detection on ´the previous array is matched to the
last detection on the target array to perform the calculations.}

\item{speed.warning}{If a tag moves at a speed equal or greater than
\code{speed.warning} (in metres per second), a warning is issued. If left
NULL (default), no warnings are issued. Must be equal to or lower than \code{speed.error}}

\item{speed.error}{If a tag moves at a speed equal or greater than
\code{speed.error} (in metres per second), user intervention is suggested.
If left NULL (default), user intervention is never suggested.}

\item{jump.warning}{If a tag crosses a number of arrays equal or greater
than \code{jump.warning} without being detected, a warning is issued. Defaults
to 2. To disable jump warnings, set to Inf. Must be equal to or lower than \code{jump.error}.}

\item{jump.error}{If a tag crosses a number of arrays equal or greater than
\code{jump.error} without being detected, user intervention is suggested.
Defaults to 3. To disable user intervention suggestions, set to Inf.}

\item{inactive.warning}{If a tag spends a number of days equal or greater
than \code{inactive.warning} in a given array at the tail of the respective
detections, a warning is issued. If left NULL (default), no warnings are
issued. Must be equal to or lower than \code{innactive.error}.}

\item{inactive.error}{If a tag spends a number of days equal or greater than
\code{inactive.error} in a given array at the tail of the respective
detections, user intervention is suggested. If left NULL (default), user
intervention is never suggested.}

\item{exclude.tags}{A vector of tags that should be excluded from the
detection data before any analyses are performed. Intended to be used if
stray tags from a different code space but with the same signal as a target
tag are detected in the study area.}

\item{override}{A vector of signals for which the user intends to manually
define which movement events are valid and invalid.}

\item{report}{Logical. Should an HTML report be created at the end of the
analysis? NOTE: Setting report to TRUE will generate an HTML file in the current
directory. Additionally, if auto.open = TRUE (default), the web browser will
automatically be launched to open the report once the function terminates.}

\item{auto.open}{Logical: Should the report be automatically opened once the
analysis is over? Defaults to TRUE. NOTE: If report = TRUE and auto.open = TRUE,
the web browser will automatically be launched to open the report once the
function terminates.}

\item{discard.orphans}{Logical: Should actel automatically discard
detections that do not fall within receiver deployment periods, or that
were recorded before the respective animals were released?}

\item{discard.first}{A threshold amount of time (in hours) that must pass after
release for the respective detections to be valid. Set to 0 to discard only
the release-to-first-detection calculations.}

\item{save.detections}{Logical: Should the processed detections be saved for
future runs?}

\item{section.warning}{If a tag has section movement events with less or equal to
\code{section.warning} detections, a warning is issued. Defaults to 1.
To disable section warnings, set to 0. Must be equal to or greater than \code{section.error}.}

\item{section.error}{If a tag has section movement events with less or equal to
\code{section.error} detections, user intervention is suggested.
Defaults to 1. To disable user intervention suggestions, set to 0.}

\item{section.minimum}{DEPRECATED: Please use section.warning and section.error instead.}

\item{timestep}{The resolution desired for the residency calculations.
One of "days" (default) or "hours".}

\item{replicates}{A list containing, for each array to which intra-array
efficiency is to be calculated: The standard names of the stations to be
used as a replicate. See the vignettes for more details.}

\item{GUI}{One of "needed", "always" or "never". If "needed", a new window is
opened to inspect the movements only when the movements table is too big to be
displayed in R's console. If "always", a graphical interface is always created
when the possibility to invalidate events emerges. If "never", a graphical
interface is never invoked. In this case, if the table to be displayed does
not fit in R's console, a temporary file will be saved and the user will be
prompted to open that file and examine it. Defaults to "needed".}

\item{save.tables.locally}{Logical: If a table must be temporarily stored into a file
for user inspection, should it be saved in the current working directory, or
in R's temporary folder?}

\item{print.releases}{Logical: Should the release sites be printed in the
study area diagrams?}

\item{detections.y.axis}{The type of y axis desired for the individual
detection plots. While the argument defaults to "auto", it can be hard-set
to one of "stations" or "arrays".}
}
\value{
A list containing:
\itemize{
\item \code{detections}: A list containing all detections for each target tag;
\item \code{valid.detections}: A list containing the valid detections for each target tag;
\item \code{spatial}: A list containing the spatial information used during the analysis;
\item \code{deployments}: A data frame containing the deployments of each receiver;
\item \code{arrays}: A list containing the array details used during the analysis;
\item \code{movements}: A list containing all movement events for each target tag;
\item \code{valid.movements}: A list containing the valid movement events for each target tag;
\item \code{section.movements}: A list containing the valid section shifts for each target tag;
\item \code{status.df}: A data frame containing summary information for each tag, including the
following columns:
\itemize{
\item \emph{Times.entered.[section]}: Total number of times the tag
entered a given section
\item \emph{Average.entry.[section]}: Average entry time at a given
section
\item \emph{Average.time.[section]}: Average time the tag spent in a
given section during each visit
\item \emph{Average.departure.[section]}: Average departure time from
a given section
\item \emph{Total.time.[section]}: Total time spent in a given section
\item \emph{Very.last.array}: Last array where the tag was detected
\item \emph{Very.last.time}: Time of the last valid detection
\item \emph{Status}: Fate assigned to the animal
\item \emph{Valid.detections}: Number of valid detections
\item \emph{Invalid.detections}: Number of invalid detections
\item \emph{Valid.events}: Number of valid events
\item \emph{Invalid.events}: Number of invalid events
\item \emph{P.type}: Type of processing:
\itemize{
\item 'Skipped' if no data was found for the tag,
\item 'Auto' if no user interaction was required,
\item 'Manual' if user interaction was suggested and the user made
changes to the validity of the events,
\item 'Overridden' if the user listed the tag in the
\code{override} argument.
}
\item \emph{Comments}: Comments left by the user during the analysis
}
\item \code{last.seen}: A data frame containing the number of tags last seen in
each study area section;
\item \code{array.times}: A data frame containing ALL the entry times of each tag
in each array;
\item \code{section.times}: A data frame containing all the entry times of each
tag in each section;
\item \code{residency.list}: A list containing the places of residency between first and last
valid detection for each tag;
\item \code{time.ratios}: A list containing the daily location per section (both in seconds spent
and in percentage of day) for each tag;
\item \code{time.positions}: A data frame showing the location where each
tag spent the most time per day;
\item \code{global.ratios}: A list containing summary tables showing the number of active tag
(and respective percentages) present at each location per day;
\item \code{efficiency}: A list containing the results of the inter-array Multi-way efficiency
calculations (see vignettes for more details);
\item \code{intra.array.CJS}: A list containing the results of the intra-array CJS calculations;
\item \code{rsp.info}: A list containing appendix information for the RSP package;
\item \code{dist.mat}: The distance matrix used in the analysis (if a valid
distance matrix was supplied)
}
}
\description{
The \code{\link{residency}} analysis runs the same initial checks as
\code{\link{explore}}, but, similarly to \code{\link{migration}}, explores
particular points of the animal behaviour. If you want to know where your animals
were in each day of the study, how many animals were in each section each day,
and other residency-focused variables, this is the analysis you are looking
for!
}
\examples{
\donttest{
# Start by moving to a temporary directory
old.wd <- getwd()
setwd(tempdir())

# Deploy the example workspace
exampleWorkspace("residency_example")

# Move your R session into the example workspace
setwd("residency_example")

# run the residency analysis. Ensure the tz argument
# matches the time zone of the study area and that the
# sections match your array names. The line below works
# for the example data.
results <- residency(tz = "Europe/Copenhagen")

# to obtain an HTML report, run the analysis with report = TRUE

# return to original working directory
setwd(old.wd)
rm(old.wd)
}

}
\seealso{
\code{\link{explore}}, \code{\link{migration}}
}
