% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaptivegpca-package.R
\name{gpca}
\alias{gpca}
\title{gPCA}
\usage{
gpca(X, Q, D = rep(1, nrow(X)), k)
}
\arguments{
\item{X}{A data matrix of size \eqn{n \times p}.}

\item{Q}{An inner product matrix for the rows, either as a \eqn{p
\times p} matrix or an eigendecomposition of such a matrix.}

\item{D}{Sample weights, a vector of length \eqn{n}.}

\item{k}{The number of components to return.}
}
\value{
A list with variable loadings on the principal axes
(\code{QV}), sample/row scores (\code{U}), the fraction of the
variance explained by each of the axes (\code{vars}).
}
\description{
Performs standard gPCA with \code{k} components on a data matrix \code{X} with
row inner product \code{Q} and weights \code{D}.
}
\examples{
data(AntibioticSmall)
out.gpca = gpca(AntibioticSmall$X, AntibioticSmall$Q, k = 2)
}
