% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale.R
\docType{methods}
\name{scaleGen}
\alias{scaleGen}
\alias{scaleGen-methods}
\alias{scaleGen,genind-method}
\alias{scaleGen,genpop-method}
\title{Compute scaled allele frequencies}
\usage{
scaleGen(x, ...)

\S4method{scaleGen}{genind}(
  x,
  center = TRUE,
  scale = TRUE,
  NA.method = c("asis", "mean", "zero"),
  truenames = TRUE
)

\S4method{scaleGen}{genpop}(
  x,
  center = TRUE,
  scale = TRUE,
  NA.method = c("asis", "mean", "zero"),
  truenames = TRUE
)
}
\arguments{
\item{x}{a \linkS4class{genind} and \linkS4class{genpop} object}

\item{...}{further arguments passed to other methods.}

\item{center}{a logical stating whether alleles frequencies should be
centred to mean zero (default to TRUE). Alternatively, a vector of numeric
values, one per allele, can be supplied: these values will be substracted
from the allele frequencies.}

\item{scale}{a logical stating whether alleles frequencies should be scaled
(default to TRUE). Alternatively, a vector of numeric values, one per
allele, can be supplied: these values will be substracted from the allele
frequencies.}

\item{NA.method}{a method to replace NA; asis: leave NAs as is; mean: replace by the mean allele frequencies; zero: replace by zero}

\item{truenames}{no longer used; kept for backward compatibility}
}
\value{
A matrix of scaled allele frequencies with genotypes
(\linkS4class{genind}) or populations in (\linkS4class{genpop}) in rows and
alleles in columns.
}
\description{
The generic function \code{scaleGen} is an analogue to the \code{scale}
function, but is designed with further arguments giving scaling options.\cr
}
\details{
Methods are defined for \linkS4class{genind} and \linkS4class{genpop}
objects.  Both return data.frames of scaled allele frequencies.
}
\examples{

\dontrun{
## load data
data(microbov)
obj <- genind2genpop(microbov)

## apply scaling
X1 <- scaleGen(obj)

## compute PCAs with and without scaling
pcaObj <- dudi.pca(obj, scale = FALSE, scannf = FALSE) # pca with no scaling
pcaX1  <- dudi.pca(X1, scale = FALSE, scannf = FALSE, nf = 100) # pca scaled using scaleGen()
pcaX2  <- dudi.pca(obj, scale = TRUE, scannf = FALSE, nf = 100) # pca scaled in-PCA

## get the loadings of alleles for the two scalings
U1 <- pcaObj$c1
U2 <- pcaX1$c1
U3 <- pcaX2$c1

## find an optimal plane to compare loadings
## use a procustean rotation of loadings tables
pro1 <- procuste(U1, U2, nf = 2)
pro2 <- procuste(U2, U3, nf = 2)
pro3 <- procuste(U1, U3, nf = 2)

## graphics
par(mfrow=c(2, 3))
# eigenvalues
barplot(pcaObj$eig, main = "Eigenvalues\n no scaling")
barplot(pcaX1$eig, main = "Eigenvalues\n scaleGen scaling")
barplot(pcaX2$eig, main = "Eigenvalues\n in-PCA scaling")
# differences between loadings of alleles
s.match(pro1$scorX, pro1$scorY, clab = 0,
        sub = "no scaling -> scaling (procustean rotation)")
s.match(pro2$scorX, pro2$scorY, clab = 0,
        sub = "scaling scaleGen -> in-PCA scaling")
s.match(pro3$scorX, pro3$scorY, clab = 0,
        sub = "no scaling -> in-PCA scaling")

}

}
\author{
Thibaut Jombart \email{t.jombart@imperial.ac.uk}
}
\keyword{manip}
\keyword{methods}
