% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{get_mixture_data}
\alias{get_mixture_data}
\title{Extractor for simulated data from two-component mixture}
\usage{
get_mixture_data(x)
}
\arguments{
\item{x}{An object of class \code{twoComp_mixt}.}
}
\value{
A numeric vector of the simulated data.
}
\description{
Get the mixture data generated from method \code{twoComp_mixt()}.
}
\examples{
sim.X <- twoComp_mixt(n = 20, weight = 0.5,
                      comp.dist = list("norm", "norm"),
                      comp.param = list(list("mean"=3, "sd"=0.5),
                                        list("mean"=0, "sd"=1)))
get_mixture_data(sim.X)

}
\author{
Xavier Milhaud \href{mailto:xavier.milhaud.research@gmail.com}{xavier.milhaud.research@gmail.com}
}
