% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting.R
\name{buildAwqlStatement}
\alias{buildAwqlStatement}
\title{AWQL Statement}
\usage{
buildAwqlStatement(reportType, startDate, endDate, attributes = NULL,
  segment = NULL, metrics = NULL, where = NULL)
}
\arguments{
\item{reportType}{The report being queries.}

\item{startDate}{The start date for the request.}

\item{endDate}{The end date for the request.}

\item{attributes}{The attributes of the report.}

\item{segment}{The segment of the report.}

\item{metrics}{The metrics of the report.}

\item{where}{The conditions of the report. (Optional)}
}
\value{
Returns the statement that will be posted to the Adwords API.
}
\description{
Build the AWQL statement before posting to the API
}
\details{
Arguments attributes, segment and metrics are not currently validated so any of these can be used for a request.
}
\examples{
buildAwqlStatement("KEYWORDS_PERFORMANCE_REPORT", "2018-01-01", "2018-01-31", 
               attributes = "AdGroupName",
               segment = "Month",
               metrics = "Clicks")
}
