% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AverageWAgg.R
\name{AverageWAgg}
\alias{AverageWAgg}
\title{Aggregation Method: AverageWAgg}
\usage{
AverageWAgg(
  expert_judgements,
  type = "ArMean",
  name = NULL,
  placeholder = FALSE,
  percent_toggle = FALSE,
  round_2_filter = TRUE
)
}
\arguments{
\item{expert_judgements}{A dataframe in the format of \link{data_ratings}.}

\item{type}{One of \code{"ArMean"}, \code{"Median"}, \code{"GeoMean"}, \code{"LOArMean"}, or \code{"ProbitArMean"}.}

\item{name}{Name for aggregation method. Defaults to \code{type} unless specified.}

\item{placeholder}{Toggle the output of the aggregation method to impute placeholder data.}

\item{percent_toggle}{Change the values to probabilities. Default is \code{FALSE}.}

\item{round_2_filter}{Note that the IDEA protocol results in both a Round 1
and Round 2 set of probabilities for each claim. Unless otherwise specified,
we will assume that the final Round 2 responses (after discussion) are being
referred to.}
}
\value{
A tibble of confidence scores \code{cs} for each \code{paper_id}.
}
\description{
Calculate one of several types of averaged best estimates.
}
\details{
This function returns the average, median and transformed averages of
best-estimate judgements for each claim.

\code{type} may be one of the following:
\loadmathjax

\strong{ArMean}: Arithmetic mean of the best estimates
\mjdeqn{\hat{p}_c\left(ArMean \right ) = \frac{1}{N}\sum_{i=1}^N B_{i,c}}{ascii}
\strong{Median}: Median of the best estimates
\mjdeqn{\hat{p}_c \left(\text{median} \right) = \text{median} \{ B^i_c\}_{i=1,...,N}}{ascii}
\strong{GeoMean}: Geometric mean of the best estimates
\mjdeqn{GeoMean_{c}=  \left(\prod_{i=1}^N  B_{i,c}\right)^{\frac{1}{N}}}{ascii}
\strong{LOArMean}: Arithmetic mean of the log odds transformed best estimates
\mjdeqn{LogOdds_{i,c}= \frac{1}{N} \sum_{i=1}^N log\left( \frac{B_{i,c}}{1-B_{i,c}}\right)}{ascii}
The average log odds estimate is then back transformed to give a final group estimate:
\mjdeqn{\hat{p}_c\left( LOArMean \right) = \frac{e^{LogOdds_{i,c}}}{1+e^{LogOdds_{i,c}}}}{ascii}
\strong{ProbitArMean}: Arithmetic mean of the probit transformed best estimates
\mjdeqn{Probit_{c}= \frac{1}{N} \sum_{i=1}^N \Phi^{-1}\left( B_{i,c}\right)}{ascii}
The average probit estimate is then back transformed to give a final group estimate:
\mjdeqn{\hat{p}_c\left(ProbitArMean \right) = \Phi\left({Probit_{c}}\right)}{ascii}
}
\examples{
\donttest{AverageWAgg(data_ratings)}

}
