% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nNeeded2.R
\name{nNeeded2}
\alias{nNeeded2}
\title{Function to compute sample size needed to achieve target power}
\usage{
nNeeded2(bta1, thta, L, alp = 0.05, pow = 0.8, ar = 0.5)
}
\arguments{
\item{bta1}{log-transform of rate ratio.}

\item{thta}{Variance of frailty parameter.}

\item{L}{Number of events}

\item{alp}{Two-sided alpha-level.}

\item{pow}{Target power.}

\item{ar}{Allocation ratio (Number control / Total)}
}
\value{
The sample size required given the input assumptions to achieve target power.
}
\description{
Computes sample size needed to achieve target power at one-sided Type I control level alp/2.
A negative estimated sample size indicates no sample size is sufficient under the input assumptions.
}
\examples{

nNeeded2(bta1 = log(0.8), thta = 1, L = 1000, alp = 0.05, pow = 0.8)

if (require("dplyr") & require("tidyr")) {

  assumptions = tibble(alp = 0.05) \%>\%
  crossing(
    L = c(500, 1000, 1500),
    RR = c(0.6, 0.7, 0.8),
    thta = c(2, 3, 4),
    pow = 0.8
  ) \%>\%
    mutate(N = nNeeded2(bta1 = log(RR), thta = thta, L = L, alp = alp, pow = pow))

  assumptions \%>\% data.frame()

}

}
