% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentinel2_single.R
\name{albedo_s2}
\alias{albedo_s2}
\title{Surface Albedo using Sentinel-2 images.}
\usage{
albedo_s2()
}
\value{
It returns in raster format (.tif) the Surface Albedo at 24h scale ("Alb_24").
}
\description{
Surface Albedo using Sentinel-2 images.
}
\examples{
library(agriwater)

# dependencies of package 'agriwater'
library(terra)

# Using a temporary folder to run example
wd <- tempdir()
initial = getwd()
setwd(wd)

# creating raster which simulate Sentinel-2 reflectances - for using
# real data, please download:
# https://drive.google.com/open?id=14E1wHNLxG7_Dh4I-GqNYakj8YJDgKLzk

xy <- matrix(rnorm(4, mean = 0.07, sd = 0.01), 2, 2)
rast <- rast(xy, crs="+proj=longlat +datum=WGS84")
ext(rast) <- c(-40.5,-40.45,-9.5,-9.45)
writeRaster(rast, file.path(wd, "B2.tif"),filetype = "GTiff", overwrite=TRUE)
xy <- matrix(rnorm(4, mean = 0.05, sd = 0.015),2, 2)
rast <- rast(xy, crs="+proj=longlat +datum=WGS84")
ext(rast) <- c(-40.5,-40.45,-9.5,-9.45)
writeRaster(rast, file.path(wd, "B3.tif"),filetype = "GTiff", overwrite=TRUE)
xy <- matrix(rnorm(4, mean = 0.03, sd = 0.018),2, 2)
rast <- rast(xy, crs="+proj=longlat +datum=WGS84")
ext(rast) <- c(-40.5,-40.45,-9.5,-9.45)
writeRaster(rast, file.path(wd, "B4.tif"),filetype = "GTiff", overwrite=TRUE)
xy <- matrix(rnorm(4, mean = 0.05, sd = 0.015),2, 2)
rast <- rast(xy, crs="+proj=longlat +datum=WGS84")
ext(rast) <- c(-40.5,-40.45,-9.5,-9.45)
writeRaster(rast, file.path(wd, "B8.tif"),filetype = "GTiff", overwrite=TRUE)
mask <- as.polygons(rast)
writeVector(mask, file.path(getwd(),"mask.shp"), overwrite=TRUE)

# using "agriwater"
albedo_s2()

#Exiting temporary folder and returning to previous workspace
setwd(initial)
}
