% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.shu.R
\name{stability.shu}
\alias{stability.shu}
\title{Stability variance}
\usage{
stability.shu(dataf, res_var, gen_var, env_var, rep_var, plotIt = TRUE)
}
\arguments{
\item{dataf}{the name of the data frame containing the data to analyze.}

\item{res_var}{the response variable.}

\item{gen_var}{the genotypes variable.}

\item{env_var}{the environments variable.}

\item{rep_var}{the replications variable.}

\item{plotIt}{a logical value specifying if plot should be drawn; default is TRUE}
}
\value{
Returns a list of two objects:
\describe{
  \item{ANOVA}{the analysis of variance table}
  \item{scores}{the data frame object of stability analysis results:}
  \itemize{
    \item{\code{bi} regression of genotype means on environmental means}
    \item{\code{t_value} t-values for gypothesis that bi=0}
    \item{\code{p_value} p-values for gypothesis that bi=0 }
    \item{\code{sigma} Shukla's stability variance value}
    \item{\code{pf_value} p-values for gypothesis that sigmai=0 }
}
}
}
\description{
This function calculates the Shukla's stability variance.
}
\examples{
data(exp_data)
stability.shu(exp_data,"yield","gen","env","rep")
}
\references{
Shukla, G.K. 1972. Some statistical aspects of partitioning genotype-environmental components of variability. Heredity 29: 237-245. doi: 10.1038/hdy.1972.87
}
