% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_python_data_management.R
\name{extract_column_from_py_dataset}
\alias{extract_column_from_py_dataset}
\title{Extract column}
\usage{
extract_column_from_py_dataset(py_dataset, column_name, format = "R")
}
\arguments{
\item{py_dataset}{\code{datasets.arrow_dataset.Dataset} data set to extract the column from.}

\item{column_name}{\code{string} Name of the column to extract.}

\item{format}{\code{string} Format of the requested data.
\itemize{
\item \code{"R"} returns the data as a R object.
\item \code{"torch"} returns the data as PyTorch tensors.
\item \code{"numpy"} returns the data as numpy array.
}}
}
\value{
Returns a \code{vector}, \code{matrix} or \code{array} for \code{format="R"}. In all other
cases the requested format is returned.
}
\description{
Function extracts the content of a column from a python data set in order to allow further operations in \emph{R}.
}
\seealso{
Other Utils Python Data Management Developers: 
\code{\link{class_vector_to_py_dataset}()},
\code{\link{create_py_dataset_cache_file_path}()},
\code{\link{data.frame_to_py_dataset}()},
\code{\link{get_batches_index}()},
\code{\link{prepare_r_array_for_dataset}()},
\code{\link{py_dataset_to_embeddings}()},
\code{\link{reduce_to_unique}()},
\code{\link{tensor_list_to_numpy}()},
\code{\link{tensor_to_numpy}()}
}
\concept{Utils Python Data Management Developers}
