% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/operators.R
\docType{methods}
\name{arithmetic}
\alias{arithmetic}
\alias{Arith,RataDie,RataDie-method}
\alias{Arith,numeric,RataDie-method}
\alias{Arith,RataDie,numeric-method}
\title{Arithmetic Operators}
\usage{
\S4method{Arith}{RataDie,RataDie}(e1, e2)

\S4method{Arith}{numeric,RataDie}(e1, e2)

\S4method{Arith}{RataDie,numeric}(e1, e2)
}
\arguments{
\item{e1, e2}{A \code{\linkS4class{RataDie}} object or a \code{\link{numeric}} vector.}
}
\value{
A \code{\link{logical}} vector.
}
\description{
Operators performing arithmetic operations.
}
\details{
\emph{Rata die} will be converted to a plain \code{numeric} vector if a computation no
longer makes sense in temporal terms.
}
\examples{
## Vectors of years
x <- fixed(c(-350, 31, 1072, 576, 1130), calendar = CE())
y <- fixed(c(1494, 1645, -869, 1440, 1851), calendar = CE())

## Move forward in time
x + y

## Move backward in time
x - y

## Not rata die anymore
x * y
}
\seealso{
Other fixed date tools: 
\code{\link{as_date}()},
\code{\link{as_decimal}()},
\code{\link{as_fixed}()},
\code{\link{as_year}()},
\code{\link{fixed}()},
\code{\link{fixed_gregorian}},
\code{\link{fixed_julian}},
\code{\link{format}()},
\code{\link{pretty}()}
}
\author{
N. Frerebeau
}
\concept{fixed date tools}
