% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finite_set.R
\name{finite_set}
\alias{finite_set}
\title{Finite set}
\description{
A finite set. It also satisfies the concept of a support.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{values}}{A vector of values.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-finite_set-new}{\code{finite_set$new()}}
\item \href{#method-finite_set-has}{\code{finite_set$has()}}
\item \href{#method-finite_set-infimum}{\code{finite_set$infimum()}}
\item \href{#method-finite_set-supremum}{\code{finite_set$supremum()}}
\item \href{#method-finite_set-dim}{\code{finite_set$dim()}}
\item \href{#method-finite_set-clone}{\code{finite_set$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finite_set-new"></a>}}
\if{latex}{\out{\hypertarget{method-finite_set-new}{}}}
\subsection{Method \code{new()}}{
Initialize a finite set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{finite_set$new(values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{values}}{A vector of values.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finite_set-has"></a>}}
\if{latex}{\out{\hypertarget{method-finite_set-has}{}}}
\subsection{Method \code{has()}}{
Determine if a value is contained in the finite set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{finite_set$has(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A vector of values.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finite_set-infimum"></a>}}
\if{latex}{\out{\hypertarget{method-finite_set-infimum}{}}}
\subsection{Method \code{infimum()}}{
Get the infimum of the finite set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{finite_set$infimum()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A numeric vector of infimums.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finite_set-supremum"></a>}}
\if{latex}{\out{\hypertarget{method-finite_set-supremum}{}}}
\subsection{Method \code{supremum()}}{
Get the supremum of the finite set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{finite_set$supremum()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A numeric vector of supremums.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finite_set-dim"></a>}}
\if{latex}{\out{\hypertarget{method-finite_set-dim}{}}}
\subsection{Method \code{dim()}}{
Get the dimension of the finite set.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{finite_set$dim()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The dimension of the finite set.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finite_set-clone"></a>}}
\if{latex}{\out{\hypertarget{method-finite_set-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{finite_set$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
