% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvn.R
\name{sample_mvn_region}
\alias{sample_mvn_region}
\title{Function for obtaining sample points for an \code{mvn} object that is within
the \code{p}-probability region. That is, it samples from the smallest region of
the distribution that contains \code{p} probability mass. This is done by first
sampling from the entire distribution, then rejecting samples that are not
in the probability region (using the statistical distance \code{mahalanobis}
from \code{mu}).}
\usage{
sample_mvn_region(n, mu, sigma, p = 0.95, ...)
}
\arguments{
\item{n}{the sample size}

\item{mu}{mean vector}

\item{sigma}{variance-covariance matrix}

\item{p}{the probability region}

\item{...}{additional arguments to pass into \code{mahalanobis}}
}
\description{
Function for obtaining sample points for an \code{mvn} object that is within
the \code{p}-probability region. That is, it samples from the smallest region of
the distribution that contains \code{p} probability mass. This is done by first
sampling from the entire distribution, then rejecting samples that are not
in the probability region (using the statistical distance \code{mahalanobis}
from \code{mu}).
}
