% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lognormal.R
\name{hazard.lognormal}
\alias{hazard.lognormal}
\title{Hazard function for a log-normal distribution.}
\usage{
\method{hazard}{lognormal}(x, ...)
}
\arguments{
\item{x}{A \code{lognormal} object.}

\item{...}{Additional arguments (not used).}
}
\value{
A function \code{function(t, log = FALSE)} returning the hazard
(or log-hazard) at \code{t}.
}
\description{
Returns a function that evaluates the log-normal hazard rate
\eqn{h(t) = f(t) / S(t)} for \eqn{t > 0}.
}
\examples{
x <- lognormal(0, 1)
h <- hazard(x)
h(1)
h(2)
}
