% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/baseline.R
\docType{methods}
\name{baseline_asls}
\alias{baseline_asls}
\alias{baseline_asls-method}
\alias{baseline_asls,numeric,numeric-method}
\alias{baseline_asls,ANY,missing-method}
\title{Asymmetric Least Squares Smoothing}
\usage{
baseline_asls(x, y, ...)

\S4method{baseline_asls}{numeric,numeric}(x, y, p = 0.01, lambda = 10^4, stop = 100)

\S4method{baseline_asls}{ANY,missing}(x, p = 0.01, lambda = 10^4, stop = 100)
}
\arguments{
\item{x, y}{A \code{\link{numeric}} vector. If \code{y} is missing, an attempt is made to
interpret \code{x} in a suitable way (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}}).}

\item{...}{Currently not used.}

\item{p}{A length-one \code{\link{numeric}} vector giving the asymmetry
(\eqn{0.001 < p < 0.1} is a good choice for a signal with positive peaks).}

\item{lambda}{A length-one \code{\link{numeric}} vector giving the smoothing parameter.}

\item{stop}{An \code{\link{integer}} giving the stopping rule (i.e. maximum number of
iterations).}
}
\value{
Returns a \code{\link{list}} with two components \code{x} and \code{y}.
}
\description{
Baseline estimation with asymmetric least squares smoothing.
}
\examples{
## X-ray diffraction
data("XRD")

## Subset from 20 to 70 degrees
XRD <- signal_select(XRD, from = 20, to = 70)

## Plot spectrum
plot(XRD, type = "l", xlab = expression(2*theta), ylab = "Count")

## Polynomial baseline
baseline <- baseline_asls(XRD, p = 0.005, lambda = 10^7)

lines(baseline, type = "l", col = "red")
}
\references{
Eilers, P. H. C. & Boelens, H. F. M. (2005). \emph{Baseline Correction with
Asymmetric Least Squares Smoothing}.
}
\seealso{
\code{\link[=signal_correct]{signal_correct()}}

Other baseline estimation methods: 
\code{\link{baseline_linear}()},
\code{\link{baseline_peakfilling}()},
\code{\link{baseline_polynomial}()},
\code{\link{baseline_rollingball}()},
\code{\link{baseline_rubberband}()},
\code{\link{baseline_snip}()}
}
\author{
P. H. C. Eilers and H. F. M. Boelens (original Matlab code)
}
\concept{baseline estimation methods}
