% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvs.R
\name{pvs}
\alias{pvs}
\title{Diagnostic performance: Predictive values from a ROC curve}
\usage{
pvs(
  roc = NULL,
  prevalence,
  thresholds = roc$thresholds,
  sensitivities = roc$sensitivities,
  specificities = roc$specificities
)
}
\arguments{
\item{roc}{Object of class pROC.}

\item{prevalence}{Prevalence of the endpoint in the study population.}

\item{thresholds}{Thresholds of the ROC curve, default is roc$thresholds.}

\item{sensitivities}{Sensitivity values of the ROC curve, default is roc$sensitivities.}

\item{specificities}{Specificity values of the ROC curve, default is roc$specificities.}
}
\value{
A data frame with the following columns:
\itemize{
\item{\code{threshold}: Thresholds of the ROC curve.}
\item{\code{sensitivity}: Sensitivity values of the ROC curve.}
\item{\code{specificity}: Specificity values of the ROC curve.}
\item{\code{prevalence}: Prevalence of the positive outcome.}
\item{\code{ppv}: Positive predictive value.}
\item{\code{npv}: Negative predictive value.}
}
}
\description{
Diagnostic performance: Predictive values from a ROC curve
}
\details{
This function computes the positive and negative predictive values
from a ROC curve, given the prevalence of the positive outcome.
}
