% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metahet.hybrid.R
\name{metahet.hybrid}
\alias{metahet.hybrid}

\title{Alternative Tests and Measures for Between-Study Inconsistency in Meta-Analysis}
\description{
Performs several alternative tests (including a hybrid test) and calculates the associated measures for assessing between-study inconsistency in meta-analysis.
}

\usage{
metahet.hybrid(y, s2, data, gam, testinf = TRUE, iter.resam = 200)
}

\arguments{
\item{y}{Numeric vector of observed effect estimates, or the name of a column in \code{data}.}

\item{s2}{Numeric vector of within-study variances corresponding to \code{y}, or the name of a column in \code{data}.}

\item{data}{Optional data frame containing the variables \code{y} and \code{s2}.}

\item{gam}{Numeric vector of power parameters \eqn{\gamma}, e.g., \code{1:8}.}

\item{testinf}{Logical; if \code{TRUE}, includes the \eqn{Q_{\infty}} statistic (maximum standardized deviation).}

\item{iter.resam}{Integer; number of bootstrap resamples used to estimate expected values and p-values.}
}

\value{
A list named \code{out} containing:
\itemize{
\item \code{E_gamma}: Vector of E-gamma statistics for each \eqn{\gamma}, including \eqn{E_{\infty}} and the hybrid \eqn{E_{Lhyb}} term.
\item \code{p_gamma}: Bootstrap p-values corresponding to each \eqn{\gamma}.
\item \code{p_hyb}: Hybrid p-value combining all \eqn{\gamma} values.
\item \code{gam}: Vector of power parameters used in the tests.
\item \code{table}: Combined summary table for reporting.
}
}

\details{
The function generalizes the adaptive sum of powered score (aSPU) framework by combining standardized powered deviations across studies. Specifically, for each power parameter gamma, it calculates a statistic that measures the average standardized deviation of individual study effects from the overall mean, with greater gamma values placing more weight on extreme deviations.

For each gamma, the expected value of this statistic is obtained through a parametric bootstrap under the null hypothesis of homogeneity. The observed statistic is then standardized by subtracting its expected value and dividing by the observed total deviation, resulting in the expected gamma (E-gamma) measure.

In addition, a hybrid test is computed by combining the p-values across all gamma values using the minimum-p combination rule. It provides an overall summary of between-study inconsistency that integrates evidence from multiple power levels.
}

\references{
Pan W, Kim J, Zhang Y, Shen X, Wei P (2014). "A powerful and adaptive association test for rare variants." \emph{Genetics}, \bold{197}(4), 1081--1095. <\doi{10.1534/genetics.114.165035}>

Xu G, Lin L, Wei P, Pan W (2016). "An adaptive two-sample test for high-dimensional means." \emph{Biometrika}, \bold{103}(3), 609--624. <\doi{10.1093/biomet/asw029}>
}

\author{
Zhiyuan Yu, Xing Xing, Lifeng Lin 
}

\examples{
data("dat.hughes")
set.seed(123)
## increase iter.resam to reduce Monte Carlo error due to resampling
metahet.hybrid(y, s2, data = dat.hughes, gam = 1:8,
  testinf = TRUE, iter.resam = 200)
}
\keyword{heterogeneity}
