% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{download_hms}
\alias{download_hms}
\title{Download wildfire smoke data}
\usage{
download_hms(
  data_format = "Shapefile",
  date = c("2018-01-01", "2018-01-01"),
  directory_to_save = NULL,
  acknowledgement = FALSE,
  download = FALSE,
  remove_command = FALSE,
  unzip = TRUE,
  remove_zip = FALSE,
  hash = FALSE
)
}
\arguments{
\item{data_format}{character(1). "Shapefile" or "KML".}

\item{date}{character(1 or 2). length of 10. Date or start/end dates for downloading data.
Format "YYYY-MM-DD" (ex. January 1, 2018 = \code{"2018-01-01"}).
NOAA HMS data is available from August 5, 2005 through present day. Data is
unavailable for August 10, 2005.}

\item{directory_to_save}{character(1). Directory to save data. If
\code{data_format = "Shapefile"}, two sub-directories will be created for the
downloaded zip files ("/zip_files") and the unzipped shapefiles
("/data_files"). If \code{data_format = "KML"}, a single sub-directory
("/data_files") will be created.}

\item{acknowledgement}{logical(1).
By setting \code{TRUE} the
user acknowledges that the data downloaded using this function may be very
large and use lots of machine storage and memory.}

\item{download}{logical(1). \code{FALSE} will generate a *.txt file
containing all download commands. By setting \code{TRUE} the function
will download all of the requested data files.}

\item{remove_command}{logical(1).
Remove (\code{TRUE}) or keep (\code{FALSE})
the text file containing download commands.}

\item{unzip}{logical(1). Unzip zip files. Default is \code{TRUE}. (Ignored
if \code{data_format = "KML"}.)}

\item{remove_zip}{logical(1). Remove zip files from
directory_to_download. Default is \code{FALSE}.
(Ignored if \code{data_format = "KML"}.)}

\item{hash}{logical(1). By setting \code{TRUE} the function will return
an \code{rlang::hash_file()} hash character corresponding to the
downloaded files. Default is \code{FALSE}.}
}
\value{
\itemize{
\item For \code{hash = FALSE}, NULL
\item For \code{hash = TRUE}, an \code{rlang::hash_file} character.
\item Zip and/or data files will be downloaded and stored in
respective sub-directories within \code{directory_to_save}.
}
}
\description{
The \code{download_hms()} function accesses and downloads
wildfire smoke plume coverage data from \href{https://www.ospo.noaa.gov/products/land/hms.html#0}{NOAA's Hazard Mapping System Fire and Smoke Product}.
}
\examples{
\dontrun{
download_hms(
  data_format = "Shapefile",
  date = "2024-01-01",
  directory_to_save = tempdir(),
  acknowledgement = TRUE,
  download = FALSE, # NOTE: download skipped for examples,
  remove_command = TRUE,
  unzip = FALSE
)
}
}
\references{
\insertRef{web_HMSabout}{amadeus}
}
\author{
Mitchell Manware, Insang Song
}
