% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amber.interviews.R
\name{amber.interviews_step_actions}
\alias{amber.interviews_step_actions}
\title{Get the actions of some interviews step}
\usage{
amber.interviews_step_actions(steps, step_name)
}
\arguments{
\item{steps}{The data frame of interviews steps}

\item{step_name}{The name of the step}
}
\value{
A data.frame of step data
}
\description{
Get the actions of the steps with a specific name.
}
\examples{
\dontrun{
a <- amber.login("https://amber-demo.obiba.org")

# Find interview records of a study
itws <- amber.interviews(a, study = "Trauma Registry")

# Get steps
steps <- amber.interviews_steps(itws)

# Get actions of the step with name QUESTIONNAIRE
actions <- amber.interviews_step_actions(steps, 'QUESTIONNAIRE')

# Count the number of completed QUESTIONNAIRE steps ('complete' action type)
# in completed interviews ('completed' state)
actions \%>\% filter(state == 'completed', type == 'complete') \%>\% count()

amber.logout(a)
}
}
\seealso{
Other studies functions: 
\code{\link{amber.campaign}()},
\code{\link{amber.campaigns}()},
\code{\link{amber.case_report_export}()},
\code{\link{amber.case_report_form}()},
\code{\link{amber.case_report_forms}()},
\code{\link{amber.case_reports}()},
\code{\link{amber.form}()},
\code{\link{amber.form_revision}()},
\code{\link{amber.form_revisions}()},
\code{\link{amber.forms}()},
\code{\link{amber.interview_design}()},
\code{\link{amber.interview_designs}()},
\code{\link{amber.interview_export}()},
\code{\link{amber.interviews}()},
\code{\link{amber.interviews_step_data}()},
\code{\link{amber.interviews_steps}()},
\code{\link{amber.participant}()},
\code{\link{amber.participants}()},
\code{\link{amber.studies}()},
\code{\link{amber.study}()}
}
\concept{studies functions}
