% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractal-ridged.R
\name{ridged}
\alias{ridged}
\alias{rigid}
\alias{rigid-multi}
\alias{spectral_gain}
\title{Ridged-Multi fractal}
\usage{
ridged(base, new, strength, octave, offset = 1, gain = 2, ...)

spectral_gain(h = 1, lacunarity = 2)
}
\arguments{
\item{base}{The prior values to modify}

\item{new}{The new values to modify \code{base} with}

\item{strength}{A value to modify \code{new} with before applying it to \code{base}}

\item{octave}{The current octave}

\item{offset}{The new values are first modified by \code{(offset - abs(new))^2}}

\item{gain}{A value to multiply the old octave by before using it to modify
the new octave}

\item{...}{ignored}

\item{h}{Each successive gain is raised to the power of \code{-h}}

\item{lacunarity}{A multiplier to apply to the previous value before raising
it to the power of \code{-h}}
}
\description{
This fractal is slightly more complex than the regular \code{\link[=fbm]{fbm()}} fractal. It
uses the prior octave to modify the values of the current octave before
adding it to the cumulating values. The result of this is that the final
values will show steep hills and larger smooth areas, resembling mountain
ranges. This function is intended to be used in conjunction with
\code{\link[=fracture]{fracture()}}
}
\details{
The ridged fractal was designed with a slightly more complex gain sequence
in mind, and while any sequence or generator would work \code{\link[=fracture]{fracture()}} should
be called with \code{gain = spectral_gain()} to mimick the original intention of
the fractal.
}
\examples{
grid <- long_grid(seq(1, 10, length.out = 1000), seq(1, 10, length.out = 1000))

grid$simplex <- fracture(gen_simplex, ridged, octaves = 8,
                         gain = spectral_gain(), x = grid$x, y = grid$y)
plot(grid, simplex)

}
\seealso{
Other Fractal functions: 
\code{\link{billow}()},
\code{\link{clamped}()},
\code{\link{fbm}()}
}
\concept{Fractal functions}
