% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rwish.R
\name{rwish}
\alias{rwish}
\title{Simulation from a Wishart distribution}
\usage{
rwish(S0, nu = dim(S0)[1] + 2)
}
\arguments{
\item{S0}{a positive definite matrix}

\item{nu}{a positive integer}
}
\value{
a positive definite matrix
}
\description{
Simulates a random Wishart-distributed matrix
}
\examples{

## The expectation is S0*nu

S0<-rwish(diag(3)) 

SS<-matrix(0,3,3) 
for(s in 1:1000) { SS<-SS+rwish(S0,5) }

SS/s 

S0*5


}
\author{
Peter Hoff
}
