% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ananke-package.R
\docType{package}
\name{ananke-package}
\alias{ananke-package}
\alias{ananke}
\title{ananke: Quantitative Chronology in Archaeology}
\description{
Simple radiocarbon calibration and chronological analysis. This package allows the calibration of radiocarbon ages and modern carbon fraction values using multiple calibration curves. It allows the calculation of highest density region intervals and credible intervals. The package also provides tools for visualising results and estimating statistical summaries.
}
\details{
\tabular{ll}{
\strong{Package:} \tab ananke \cr
\strong{Type:} \tab Package \cr
\strong{Version:} \tab 0.1.0 \cr
\strong{License:} \tab GPL-3 \cr
}
}
\section{Package options}{

\pkg{ananke} uses the following \code{\link[=options]{options()}} to configure behavior:
\itemize{
\item \code{ananke.grid}: a \code{\link{numeric}} value specifying the number of equally
spaced points at which densities are to be estimated (defaults to
\eqn{512}). Should be a power of \eqn{2} (see \code{\link[stats:density]{stats::density()}}).
\item \code{ananke.round}: a \code{\link{character}} string specifying the rounding convention.
It can be one of "\code{none}" (the default, no rounding) or "\code{stuiver}"
(Stuiver & Polach, 1977).
\item \code{ananke.progress}: a \code{\link{logical}} scalar. Should progress bars be
displayed? Defaults to \code{\link[=interactive]{interactive()}}.
\item \code{ananke.verbose}: a \code{\link{logical}} scalar. Should \R report extra information
on progress? Defaults to \code{\link[=interactive]{interactive()}}.
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://codeberg.org/tesselle/ananke}
  \item \url{https://packages.tesselle.org/ananke/}
  \item Report bugs at \url{https://codeberg.org/tesselle/ananke/issues}
}

}
\author{
\strong{Full list of authors and contributors} (alphabetic order):

\tabular{ll}{
Nicolas Frerebeau \tab \emph{Université Bordeaux Montaigne, France} \cr
}

\strong{Package maintainer}

Nicolas Frerebeau\cr
\email{nicolas.frerebeau@u-bordeaux-montaigne.fr}

Archéosciences Bordeaux (UMR 6034)\cr
Maison de l'Archéologie\cr
Université Bordeaux Montaigne\cr
F-33607 Pessac cedex\cr
France
}
\keyword{internal}
