% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proportional-shade.R
\name{proportional_shade}
\alias{proportional_shade}
\title{Proportional shaded data}
\usage{
proportional_shade(
  initial = NULL,
  proportion = NULL,
  y = NULL,
  position = "left"
)
}
\arguments{
\item{initial}{A numerical of initial values for the proportional shade.}

\item{proportion}{A vector of proportions corresponding to each group.}

\item{y}{A numeric vector specifying the vertical position of the shade diagram.}

\item{position}{A character string specifying the side of the shade diagram.
This needs to be either "left" (default) or "right".}
}
\value{
A data frame of the proportional shaded diagram.
}
\description{
This function creates a proportional shaded data using the specified parameters.
}
\examples{
data <- proportional_shade(4, c(0.4, 0.3, 0.2, 0.1), c(4, 3, 2, 1))

ggplot2::ggplot(data = data, ggplot2::aes(x = x, y = y, group = id, fill = as.factor(id))) +
  ggplot2::geom_polygon(alpha = 0.1)

}
\keyword{internal}
