% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_zarr.R
\name{write_zarr}
\alias{write_zarr}
\title{Write a hierarchical Zarr array store.}
\usage{
write_zarr(anndata, store, chunks = NULL)
}
\arguments{
\item{anndata}{An \code{\link[=AnnData]{AnnData()}} object}

\item{store}{The filename, a MutableMapping, or a Zarr storage class.}

\item{chunks}{Chunk shape.}
}
\description{
Write a hierarchical Zarr array store.
}
\examples{
\dontrun{
ad <- AnnData(
  X = matrix(c(0, 1, 2, 3), nrow = 2, byrow = TRUE),
  obs = data.frame(group = c("a", "b"), row.names = c("s1", "s2")),
  var = data.frame(type = c(1L, 2L), row.names = c("var1", "var2")),
  varm = list(
    ones = matrix(rep(1L, 10), nrow = 2),
    rand = matrix(rnorm(6), nrow = 2),
    zeros = matrix(rep(0L, 10), nrow = 2)
  ),
  uns = list(a = 1, b = 2, c = list(c.a = 3, c.b = 4))
)

ad$write_zarr("output.zarr")
write_zarr(ad, "output.zarr")

unlink("output.zarr", recursive = TRUE)
}
}
