% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transpose.r
\name{transpose}
\alias{transpose}
\alias{t.annmatrix}
\title{Transposing annmatrix Objects}
\usage{
\method{t}{annmatrix}(x)
}
\arguments{
\item{x}{annmatrix object.}
}
\value{
transposed annmatrix object with appropriately adjusted row and column annotations.
}
\description{
Transpose annmatrix along with the associated row and column annotations.
}
\examples{
# construct annmatrix object
x <- matrix(rnorm(20*10), 20, 10)

coldata <- data.frame(group  = rep(c("case", "control"), each = 5),
                      gender = sample(c("M", "F"), 10, replace = TRUE))

rowdata <- data.frame(chr = sample(c("chr1", "chr2"), 20, replace = TRUE),
                      pos = runif(20, 0, 1000000))

X <- annmatrix(x, rowdata, coldata)

# transposes the main matrix along with row and column annotations
Xt <- t(X)

print(X)
print(Xt)

X@chr
Xt$chr

}
\author{
Karolis Koncevičius
}
