% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_disease_links.R
\name{add_disease_links}
\alias{add_disease_links}
\title{Add disease association data}
\usage{
add_disease_links(annotaR_object, score_threshold = 0.5)
}
\arguments{
\item{annotaR_object}{A tibble, typically from \code{annotaR()}, containing a
'gene' column with HGNC symbols.}

\item{score_threshold}{Minimum association score (from 0 to 1) to include.
Defaults to 0.5.}
}
\value{
A new tibble with the original data joined with disease association
columns (disease_name, association_score).
}
\description{
Augments an annotaR object with disease association data from the
OpenTargets platform.
}
\examples{
\donttest{
  annotaR(c("TP53", "EGFR")) \%>\%
    add_disease_links(score_threshold = 0.8)
}
}
