% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pass.R
\name{pass}
\alias{pass}
\title{Detection of multivariate anomalous segments using PASS.}
\usage{
pass(x, alpha = 2, lambda = NULL, max_seg_len = 10, min_seg_len = 1)
}
\arguments{
\item{x}{A numeric matrix with n rows and p columns containing the data which is to be inspected. The time series data classes ts, xts, and zoo are also supported.}

\item{alpha}{A positive integer > 0. This value is used to stabilise the higher criticism based test statistic used by PASS leading to a better finite sample familywise error rate. 
Anomalies affecting fewer than alpha components will however in all likelihood escape detection. The default is 2.}

\item{lambda}{A positive real value setting the threshold value for the familywise Type 1 error. The default value
is \eqn{(1.1 {\rm log}(n \times max\_seg\_len) +2 {\rm log}({\rm log}(p))) / \sqrt{{\rm log}({\rm log}(p))}}.}

\item{max_seg_len}{A positive integer (\code{max_seg_len} > 0) corresponding to the maximum interval length. This parameter corresponds to L in Jeng et al. (2012). The default value is 10.}

\item{min_seg_len}{A positive integer (\code{max_seg_len} >= \code{min_seg_len} > 0) corresponding to the minimum segment length.
The default value is 1.}
}
\value{
An instance of an S4 object of type \code{.pass.class} containing the data \code{X}, procedure parameter values, and the results.
}
\description{
Implements the PASS (Proportion Adaptive Segment Selection) procedure of Jeng et al. (2012). PASS uses a higher criticism statistic to pool the information about the 
presence or absence of a collective anomaly across the components. It uses Circular Binary Segmentation to detect multiple collective anomalies.
}
\examples{
library(anomaly)
# generate some multivariate data
data(simulated)
res<-pass(sim.data)
summary(res)
plot(res,variate_names=TRUE)

}
\references{
\insertRef{10.1093/biomet/ass059}{anomaly}

\insertRef{JSS-anomaly-paper-final}{anomaly}
}
