% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thermalGeneration.R
\name{thermalGroupCapacities}
\alias{thermalGroupCapacities}
\title{compute thermal capacities from study}
\usage{
thermalGroupCapacities(opts = simOptions())
}
\arguments{
\item{opts}{\code{simOptions} obtain which \link[antaresRead]{setSimulationPath}}
}
\value{
A data.table, data.frame class object containing computed result by areas/clusters
}
\description{
compute thermal capacities from study
}
\examples{
\donttest{
library(antaresRead)
# with study test for example (study is in package antaresRead)
sourcedir <- system.file("testdata", package = "antaresRead")

# untar study in temp dir
path_latest <- file.path(tempdir(), "latest")
untar(file.path(sourcedir, "antares-test-study.tar.gz"), exdir = path_latest)

study_path <- file.path(path_latest, "test_case")

# set path to your Antares simulation
opts <- setSimulationPath(study_path)

mydata <- readAntares( areas = "all",
                       mcYears = "all", showProgress = FALSE)

# long to wide format
res <- thermalGroupCapacities(opts = opts)
}
}
