% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residual_plot_helpers.R
\name{arg_check_residual_plot_lm}
\alias{arg_check_residual_plot_lm}
\title{Check arguments of residual_plot.lm}
\usage{
arg_check_residual_plot_lm(
  rtype,
  xaxis,
  id_n,
  smooth,
  add_reference,
  add_smooth,
  text_arglist,
  abline_arglist,
  smooth_arglist,
  lines_arglist,
  extendrange_f
)
}
\arguments{
\item{rtype}{The residual type to plot. The default is
\code{"ordinary"}. The other options are
\code{"standardized"}, \code{"studentized"},
\code{"loo"}, \code{"jackknife"}, \code{"deleted"},
\code{"internally studentized"}, \code{"externally
studentized"}.}

\item{xaxis}{The variable to use on the x-axis of the
plot(s). The default is \code{"fitted"} to use fitted
values. The other option is \code{"predictors"}.}

\item{id_n}{The number of points to identify with labels.
The default is \code{3}.}

\item{smooth}{A function with a
\code{\link[stats]{formula}} argument to smooth the
desired plot. The default function is
\code{\link[stats]{loess}.}}

\item{add_reference}{A logical value indicating whether a
reference line should be added. The default is
\code{TRUE}.}

\item{add_smooth}{A logical value indicating whether a
smooth should be added to each plot produced. The
default is \code{TRUE}.}

\item{text_arglist}{Additional arguments passed to the
\code{\link[graphics]{text}} function, which is used to
display the points that are identified.}

\item{abline_arglist}{A named list specifying additional
arguments passed to the \code{\link[graphics]{abline}}
function for the horizontal reference line added to the
plot.}

\item{smooth_arglist}{A named list specifying additional
arguments passed to the function provided in the
\code{smooth} argument.}

\item{lines_arglist}{A named list specifying additional
arguments passed to the \code{\link[graphics]{lines}}
function for plotting the result of applying the
\code{smooth} function.}

\item{extendrange_f}{Positive number(s) specifying the
fraction by which the range of the residuals should be
extended using the \code{\link[grDevices]{extendrange}}
function. If longer than one, \code{f[1]} is used on
the left and \code{f[2]} on the right.}
}
\description{
Check arguments of residual_plot.lm
}
\keyword{internal}
