% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ash_request.R
\name{ash_request}
\alias{ash_request}
\title{Appsheet request builder}
\usage{
ash_request(
  tableName,
  Action = "Find",
  Properties = ash_properties(),
  Rows = list(),
  appId = Sys.getenv("APPSHEET_APP_ID"),
  access_key = Sys.getenv("APPSHEET_APP_ACCESS_KEY")
)
}
\arguments{
\item{tableName}{The name of the table to perform actions on.}

\item{Action}{The action to be performed on the table, one of ("Find", "Add", "Delete", "Edit").
Default is "Find", which reads a table.}

\item{Properties}{A list of properties for the action. \code{ash_properties()} provides sensible defaults, but can be customized.}

\item{Rows}{A list of rows for the action. Default is an empty list.}

\item{appId}{The AppSheet application ID. Default is retrieved from the APPSHEET_APP_ID environment variable.}

\item{access_key}{The AppSheet application access key. Default is retrieved from the APPSHEET_APP_ACCESS_KEY environment variable.}
}
\value{
An httr2 request
}
\description{
Appsheet request builder
}
