% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilProfileCollection-metadata.R
\docType{methods}
\name{hzmetaname}
\alias{hzmetaname}
\alias{hzmetaname,SoilProfileCollection-method}
\alias{hzmetaname<-}
\alias{hzmetaname<-,SoilProfileCollection-method}
\title{Get or Set Horizon Metadata Column Name}
\usage{
\S4method{hzmetaname}{SoilProfileCollection}(object, attr, required = FALSE)

\S4method{hzmetaname}{SoilProfileCollection}(object, attr, required = FALSE) <- value
}
\arguments{
\item{object}{A \emph{SoilProfileCollection}}

\item{attr}{\emph{character}. Base name for attribute to be stored in metadata. This is prefixed with \code{"aqp_hz"} for horizon-level metadata for column attributes. e.g. \code{attr="clay"} results in metadata value retrieved from \code{"aqp_hzclay"}.}

\item{required}{\emph{logical}. Is this attribute required? If it is, set to \code{TRUE} to trigger error on invalid \code{value}.}

\item{value}{\emph{character}. Name of horizon-level column containing  data corresponding to \code{attr}.}
}
\description{
\code{hzmetaname()}: Get column name containing horizon data of interest

\verb{hzmetaname<-}: Set horizon designation column name
}
\details{
Store the column name containing a specific type of horizon data in the metadata slot of the SoilProfileCollection.
}
\examples{

data(sp1)

# promote to SPC
depths(sp1) <- id ~ top + bottom

# set important metadata columns
hzdesgnname(sp1) <- "name"
hztexclname(sp1) <- "texture"

# set custom horizon property (clay content) column
hzmetaname(sp1, "clay") <- "prop"

# inspect metadata list
metadata(sp1)

# get horizon clay content column
hzmetaname(sp1, "clay")

# uses hzdesgname(), hztexclname(), hzmetaname(attr="clay") in function definition
estimatePSCS(sp1)
}
\seealso{
\code{\link[=guessHzAttrName]{guessHzAttrName()}}
}
