% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feed_conversion.R
\name{fcr}
\alias{fcr}
\title{Feed Conversion Ratio (FCR)}
\usage{
fcr(ibw, fbw, feed, dm = 1)
}
\arguments{
\item{ibw}{numeric; value that is providing the initial weight in
grams.}

\item{fbw}{numeric; value that is providing the final weight in
grams.}

\item{feed}{numeric; value providing the feed fed in grams during the 
experiment.}

\item{dm}{numeric; value within the interval of ]0:1], indicating the 
relative dry matter content of the feed.}
}
\value{
returns a numeric value that is the FCR.
}
\description{
A function that calculates the Feed Conversion Ratio (FCR) based on
the Initial Body weight (IBW; ibw) in gram (g), the Final Body
Weight (FBW; fbw) in gram (g), the Feed fed (Ff; ff) in gram and the
dry matter (DM; dm) content of the feed in percent.
}
\details{
The Feed Conversion Ratio (FCR) describes the amount of feed on dry matter
(DM) basis that is required to gain 1 kg of body weight on wet weight basis.
Depending on whether the Feed fed refers to the total amount of feed 
administered or the total amount corrected for non-eaten feed, the result 
resembles the economic FCR (eFCR) or the biological FCR (bFCR), respectively 
(Glencross et al., 2024).
}
\examples{
# Feed intake = 1500 g
# Feed dry matter = 0.96 g/g (= 96\%)
# Initial bodyweight = 100 g
# Final bodyweight = 1000 g

fcr(100, 1000, 1500, 0.96)

}
\references{
Lugert, V., Thaller, G., Tetens, J., Schulz, C., & Krieter, J.
(2016): A review on fish growth calculation: multiple functions in fish
production and their specific application. Reviews in Aquaculture, 8,
p.30–42.

Glencross, B., Bachis, E., Robb, D., & Newton, R. (2024): The evolution of
sustainability metrics for the marine ingredient sector: Moving towards
holistic assessments of aquaculture feed. Reviews in Fisheries Science &
Aquaculture, 32(4), p.545-561.
}
\author{
Anıl Axel Tellbüscher
}
