% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sharing.R
\name{arc_item}
\alias{arc_item}
\title{Portal Item Metadata}
\usage{
arc_item(item_id, host = arc_host(), token = arc_token())
}
\arguments{
\item{item_id}{the ID of the item to fetch. A scalar character.}

\item{host}{default \code{"https://www.arcgis.com"}. The host of your ArcGIS Portal.}

\item{token}{an \code{httr2_token} as created by \code{auth_code()} or similar}
}
\value{
an object of class \code{PortalItem} which is a list with the item's metadata.
}
\description{
Given the unique ID of a content item, fetches the item's metadata from a portal.
}
\details{
See \href{https://developers.arcgis.com/rest/users-groups-and-items/item/}{API Reference} for more information.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
arc_item("9df5e769bfe8412b8de36a2e618c7672")
\dontshow{\}) # examplesIf}
}
\seealso{
Other portal item: 
\code{\link{arc_item_data}()}
}
\concept{portal item}
