% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/portal-users.R
\name{arc_portal_users}
\alias{arc_portal_users}
\title{Portal Users}
\usage{
arc_portal_users(
  id = arc_portal_self(token)[["id"]],
  sort_field = NULL,
  provider = NULL,
  sort_order = NULL,
  role = NULL,
  fullname = NULL,
  username = NULL,
  firstname = NULL,
  lastname = NULL,
  filter_intersection = NULL,
  page_size = 50,
  max_pages = Inf,
  .progress = TRUE,
  host = arc_host(),
  token = arc_token()
)
}
\arguments{
\item{id}{the portal ID. By default it fetches the \code{id} from \code{\link[=arc_portal_self]{arc_portal_self()}}.}

\item{sort_field}{optional field to sort by. It must be one of "username", "fullname", "created", "lastlogin", "mfaenabled", "level", "role".}

\item{provider}{optional filter users based on their identity provider. Must be one of "arcgis", "enterprise", "facebook", "google", "apple", or "github".}

\item{sort_order}{optional order to sort by. It must be one of \code{"asc"} or \code{"desc"}.}

\item{role}{optional role to filter down to. It must be one of "org_admin", "org_publisher", "org_user".}

\item{fullname}{optional string of the user's fullanme to search for.}

\item{username}{optional string of the user's user name to search for.}

\item{firstname}{optional string of the user's first name to search for.}

\item{lastname}{optional string of the user's last name to search for.}

\item{filter_intersection}{optional boolean value. If \code{TRUE} mutliple filters are treated as an \code{"and"} condition. If \code{FALSE}, treated as an \code{"or"}.}

\item{page_size}{a scalar integer between 1 and 100 indicating the number of responses per page.}

\item{max_pages}{the maximum number of pages to fetch. By default fetches all pages.}

\item{.progress}{default \code{TRUE}. Whether to display a progress bar for requests.}

\item{host}{default \code{"https://www.arcgis.com"}. The host of your ArcGIS Portal.}

\item{token}{an object of class \code{httr2_token} as generated by \code{\link[=auth_code]{auth_code()}}
or related function}
}
\value{
a data.frame of users.
}
\description{
This function lists all users in a portal.
}
\examples{
\dontrun{
set_arc_token(auth_user())
arc_portal_users()
}
}
\references{
\href{https://developers.arcgis.com/rest/users-groups-and-items/users/}{API Reference}
}
\seealso{
Other portal: 
\code{\link{arc_portal_resources}()},
\code{\link{arc_portal_urls}()},
\code{\link{self}}
}
\concept{portal}
