% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aread.R
\name{aread}
\alias{aread}
\title{Read Artifacts Given as md5hashes from the Repository}
\usage{
aread(md5hash)
}
\arguments{
\item{md5hash}{One of the following:

A character vector which elements  are consisting of at least three components separated with '/': Remote user name, Remote repository and name of the artifact (MD5 hash) or it's abbreviation.

MD5 hashes of artifacts in current local default directory or its abbreviations.}
}
\description{
\code{aread} reads the artifact from the \link{Repository}. It's a wrapper around 
\link{loadFromLocalRepo} and \link{loadFromRemoteRepo}.
}
\details{
Function \code{aread} reads artifacts (by \code{md5hashes}) from Remote Repository.
It uses \link{loadFromLocalRepo} and \link{loadFromRemoteRepo} functions
with different parameter's specification.
}
\note{
Before you start using this function, remember to set local or Remote repository
to default by using \code{setLocalRepo()} or \code{setRemoteRepo} functions.
}
\section{Contact}{

 
Bug reports and feature requests can be sent to 
\href{https://github.com/pbiecek/archivist/issues}{https://github.com/pbiecek/archivist/issues}
}

\examples{
# read the object from local directory
setLocalRepo(system.file("graphGallery", package = "archivist"))
pl <- aread("7f3453331910e3f321ef97d87adb5bad")
# To plot it remember to have ggplot2 in version 2.1.0
# as this is stated in asession("7f3453331910e3f321ef97d87adb5bad") .
# The state of R libraries can be restored to the same state in
# which 7f3453331910e3f321ef97d87adb5bad was created with the restoreLibs function.

# read the object from Remote
# pl <- aread("pbiecek/graphGallery/7f3453331910e3f321ef97d87adb5bad")
# To plot it remember to have ggplot2 in version 2.1.0
# as this is stated in asession("pbiecek/graphGallery/7f3453331910e3f321ef97d87adb5bad") .
# The state of R libraries can be restored to the same state in
# which 7f3453331910e3f321ef97d87adb5bad was created with the restoreLibs function.
}
\references{
Biecek P and Kosinski M (2017). "archivist: An R Package for Managing,
Recording and Restoring Data Analysis Results." _Journal of Statistical
Software_, *82*(11), pp. 1-28. doi: 10.18637/jss.v082.i11 (URL:
http://doi.org/10.18637/jss.v082.i11).
URL https://github.com/pbiecek/archivist
}
\seealso{
Other archivist: 
\code{\link{Repository}},
\code{\link{Tags}},
\code{\link{\%a\%}()},
\code{\link{addHooksToPrint}()},
\code{\link{addTagsRepo}()},
\code{\link{aformat}()},
\code{\link{ahistory}()},
\code{\link{alink}()},
\code{\link{aoptions}()},
\code{\link{archivistPackage}},
\code{\link{areadLocal}()},
\code{\link{asearch}()},
\code{\link{asearchLocal}()},
\code{\link{asession}()},
\code{\link{atrace}()},
\code{\link{cache}()},
\code{\link{copyLocalRepo}()},
\code{\link{createLocalRepo}()},
\code{\link{createMDGallery}()},
\code{\link{deleteLocalRepo}()},
\code{\link{getRemoteHook}()},
\code{\link{getTagsLocal}()},
\code{\link{loadFromLocalRepo}()},
\code{\link{md5hash}},
\code{\link{removeTagsRepo}()},
\code{\link{restoreLibs}()},
\code{\link{rmFromLocalRepo}()},
\code{\link{saveToLocalRepo}()},
\code{\link{searchInLocalRepo}()},
\code{\link{setLocalRepo}()},
\code{\link{shinySearchInLocalRepo}()},
\code{\link{showLocalRepo}()},
\code{\link{splitTagsLocal}()},
\code{\link{summaryLocalRepo}()},
\code{\link{zipLocalRepo}()}
}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\concept{archivist}
