% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_check_lang.R
\name{check_lang}
\alias{check_lang}
\title{Check if text is language-appropriate}
\usage{
check_lang(strings, detailed = FALSE)
}
\arguments{
\item{strings}{character. Vector of strings containing document sentences.}

\item{detailed}{bool. If TRUE, the full cld2 report is returned as well.}
}
\value{
logical. If \code{TRUE} the language of the string is mostly English. 
If \code{detailed} is \code{TRUE} a list is instead returned for the full document.
}
\description{
Many, if not all, large language models are biased to English 
terms and sentence constructions. This function performs a quick check with
\code{\link[cld2:detect_language]{cld2}} over every element of a string of
characters and returns whether it is mostly (75% of the document) in English.
}
\examples{
# English 
check_lang("Species Macrothele calpeiana is found in Alentejo.")

# Portuguese
check_lang("A espécie Macrothele calpeiana é encontrada no Alentejo.")
}
