% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_create_training_data.R
\name{create_training_data}
\alias{create_training_data}
\title{Create training data for GPT}
\usage{
create_training_data(
  input,
  prompt = NULL,
  service = "GPT",
  aggregate = TRUE,
  export_type = "jsonl",
  out_path = NULL
)
}
\arguments{
\item{input}{character or list. Either a set of paths to WebAnno TSV 3.3 files from which the text and annotated data are taken or a list with two terms,
1) paths to \code{.txt} or \code{.pdf} files e.g: \code{"./folder/file.pdf"} from which text data will be taken from and 2) paths to WebAnno TSV 3.3 files from which to take annotation data.}

\item{prompt}{character. Custom prompt to be attached to each \code{text} during construction of the training data. Default prompt used otherwise.}

\item{service}{character. Service to be used. Right now, only \code{GPT} is available.}

\item{aggregate}{boolean. If TRUE and prompt is \code{"csv"}, a single csv is created.}

\item{export_type}{character. Either \code{"jsonl"} or \code{"csv"}. If \code{"jsonl"}, a single file is created in which each line is a json specifying the input (\code{prompt} and \code{text}) and expected output (\code{data}).}

\item{out_path}{character. Path to where the training data will be saved.}
}
\value{
matrix / data.frame
}
\description{
Open WebAnnoTSV files following RECODE structure and build training data for large language models in a variety of formats.
}
\examples{
example = system.file(paste0("extdata/insecta_annot_1.tsv"), package = "arete")

create_training_data(input = example, service = "GPT", export_type = "jsonl")
}
