% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_driven_lambda.R
\name{lambda.adaptive.enlarge}
\alias{lambda.adaptive.enlarge}
\title{Iteratively enlarge a tuning parameter \eqn{\lambda} in a data-driven way.}
\usage{
lambda.adaptive.enlarge(
  lambda,
  scaled.difference.matrix,
  sample.mean = NULL,
  mult.factor = 2,
  verbose = FALSE,
  seed = NULL,
  ...
)
}
\arguments{
\item{lambda}{The real-valued tuning parameter for exponential weightings (the calculation of softmin).}

\item{scaled.difference.matrix}{A n by (p-1) difference scaled.difference.matrix matrix after column-wise scaling (reference dimension - the rest);
each of its row is a (p-1)-dimensional vector of differences.}

\item{sample.mean}{The sample mean of the n samples in scaled.difference.matrix; defaults to NULL. It can be calculated via colMeans(scaled.difference.matrix).
If your experiment involves hypothesis testing over more than one dimension, pass sample.mean=colMeans(scaled.difference.matrix) to speed up computation.}

\item{mult.factor}{In each iteration, \eqn{\lambda} would be multiplied by mult.factor to yield an enlarged \eqn{\lambda}; defaults to 2.}

\item{verbose}{A boolean value indicating if the number of iterations should be printed to console; defaults to FALSE.}

\item{seed}{(Optional) If provided, used to seed for tie-breaking (for reproducibility).}

\item{...}{Additional arguments to \link{is.lambda.feasible.LOO}.}
}
\value{
A list containing:
\tabular{ll}{
  \code{lambda} \tab The final (enlarged) lambda that is still feasible. \cr
  \tab \cr
  \code{capped} \tab Logical, \code{TRUE} if the enlargement was capped due to reaching the threshold. \cr
  \tab \cr
  \code{residual.slepian} \tab Residual value from the feasibility check at the final lambda. \cr
  \tab \cr
  \code{variance.bound} \tab Variance bound used in the final feasibility check. \cr
}
}
\description{
Iteratively enlarge a tuning parameter \eqn{\lambda} to enhance the power of hypothesis testing.
The iterative algorithm ends when an enlarged \eqn{\lambda} unlikely yields the first order stability.
}
\examples{
# Simulate data
set.seed(123)
r <- 4
n <- 200
mu <- (1:20)/20
cov <- diag(length(mu))
set.seed(108)
data <- MASS::mvrnorm(n, mu, cov)
sample.mean <- colMeans(data)
diff.mat <- get.difference.matrix(data, r)
sample.mean.r <- get.sample.mean.r(sample.mean, r)
lambda <- lambda.adaptive.LOO(diff.mat, sample.mean=sample.mean.r)

# Run the enlargement algorithm
res <- lambda.adaptive.enlarge(lambda, diff.mat, sample.mean=sample.mean.r)
res
# with a seed
res <- lambda.adaptive.enlarge(lambda, diff.mat, sample.mean=sample.mean.r, seed=3)
res

}
