% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical_functions.R
\name{anova_sspd}
\alias{anova_sspd}
\title{Split-Split Plot Design ANOVA}
\usage{
anova_sspd(
  data,
  response,
  main_plot,
  sub_plot,
  sub_sub_plot,
  replication,
  verbose = TRUE
)
}
\arguments{
\item{data}{Data frame containing the experimental data}

\item{response}{Name of the response variable (as string)}

\item{main_plot}{Name of main plot factor}

\item{sub_plot}{Name of sub-plot factor}

\item{sub_sub_plot}{Name of sub-sub-plot factor}

\item{replication}{Name of replication/block factor}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
List containing ANOVA table, means, and significance tests
}
\description{
Performs complete ANOVA for Split-Split Plot Design with proper error terms
for main plot, sub-plot, and sub-sub-plot factors. Generates publication-ready
ANOVA table with significance levels.
}
\examples{
# Example with sample data
data <- expand.grid(rep=1:3, A=c('A1','A2'), B=c('B1','B2'), C=c('C1','C2'))
data$yield <- rnorm(24, 1200, 150)
anova_sspd(data, response='yield', main_plot='A', sub_plot='B',
           sub_sub_plot='C', replication='rep')

}
\author{
Lalit Kumar Rolaniya, ICAR-IIPR, Bikaner
}
