% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical_functions.R
\name{path_analysis}
\alias{path_analysis}
\title{Path Coefficient Analysis}
\usage{
path_analysis(data, dependent, independent, digits = 4, verbose = TRUE)
}
\arguments{
\item{data}{Data frame with numeric variables}

\item{dependent}{Name of dependent variable (e.g., "yield")}

\item{independent}{Character vector of independent variable names}

\item{digits}{Number of decimal places}

\item{verbose}{Logical. If TRUE (default), prints formatted output to console.}
}
\value{
List with direct effects, indirect effects, and correlation breakdown
}
\description{
Performs path analysis to determine direct and indirect effects of
independent variables on a dependent variable. Essential for 
understanding yield contributing factors.
}
\examples{
data <- data.frame(
  yield = c(1200, 1350, 1100, 1450, 1280, 1380, 1220, 1400),
  pods = c(45, 52, 42, 58, 48, 54, 46, 56),
  seeds = c(8.2, 9.1, 7.8, 9.5, 8.5, 9.0, 8.3, 9.3),
  weight = c(32, 35, 30, 38, 33, 36, 31, 37)
)
path_analysis(data, dependent = "yield", 
              independent = c("pods", "seeds", "weight"))

}
\author{
Lalit Kumar Rolaniya, ICAR-IIPR, Bikaner
}
