% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eclat.R
\name{eclat}
\alias{eclat}
\alias{ECLAT}
\alias{Eclat}
\title{Mining Associations with Eclat}
\usage{
eclat(data, parameter = NULL, control = NULL, ...)
}
\arguments{
\item{data}{object of class \link{transactions}. Any data
structure which can be coerced into transactions (e.g.,
a logical matrix, a data.frame or a tibble) can also be specified and will be
internally coerced to transactions. However, it is recommended to first create
a transactions object using \code{\link[=transactions]{transactions()}} and then to check that items are
correctly created.}

\item{parameter}{object of class \link{ECparameter} or named
list (default values are: support 0.1 and maxlen 5)}

\item{control}{object of class \link{ECcontrol} or named list
for algorithmic controls.}

\item{...}{Additional arguments are added for convenience to the parameter list.}
}
\value{
Returns an object of class \link{itemsets}.
}
\description{
Mine frequent itemsets with the Eclat algorithm.  This algorithm uses simple
intersection operations for equivalence class clustering along with
bottom-up lattice traversal.
}
\details{
Calls the C implementation of the Eclat algorithm by Christian Borgelt for
mining frequent itemsets.

Eclat can also return the transaction IDs for each found itemset using
\code{tidLists = TRUE} as a parameter and the result can be retrieved as a
\link{tidLists} object with method \code{tidLists()} for class
\link{itemsets}.  Note that storing transaction ID lists is
very memory intensive, creating transaction ID lists only works for minimum
support values which create a relatively small number of itemsets.  See also
\code{\link[=supportingTransactions]{supportingTransactions()}}.

\code{\link[=ruleInduction]{ruleInduction()}} can be used to generate rules from the found
itemsets.

A weighted version of ECLAT is available as function \code{\link[=weclat]{weclat()}}.
This version can be used to perform weighted association rule mining (WARM).
}
\examples{
data("Adult")
## Mine itemsets with minimum support of 0.1 and 5 or less items
itemsets <- eclat(Adult,
  parameter = list(supp = 0.1, maxlen = 5)
)
itemsets

## Create rules from the frequent itemsets
rules <- ruleInduction(itemsets, confidence = .9)
rules
}
\references{
Mohammed J. Zaki, Srinivasan Parthasarathy, Mitsunori Ogihara,
and Wei Li. (1997) \emph{New algorithms for fast discovery of association
rules}.  KDD'97: Proceedings of the Third International Conference on
Knowledge Discovery and Data Mining, August 1997, Pages 283-286.

Christian Borgelt (2003) Efficient Implementations of Apriori and Eclat.
\emph{Workshop of Frequent Item Set Mining Implementations} (FIMI 2003,
Melbourne, FL, USA).

ECLAT Implementation: \url{https://borgelt.net/eclat.html}
}
\seealso{
Other mining algorithms: 
\code{\link{APappearance-class}},
\code{\link{AScontrol-classes}},
\code{\link{ASparameter-classes}},
\code{\link{apriori}()},
\code{\link{fim4r}()},
\code{\link{ruleInduction}()},
\code{\link{weclat}()}
}
\author{
Michael Hahsler and Bettina Gruen
}
\concept{mining algorithms}
\keyword{models}
