% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warm.R
\name{hits}
\alias{hits}
\title{Computing Transaction Weights With HITS}
\usage{
hits(
  data,
  iter = 16L,
  tol = NULL,
  type = c("normed", "relative", "absolute"),
  verbose = FALSE
)
}
\arguments{
\item{data}{an object of or coercible to class \link{transactions}.}

\item{iter}{an integer value specifying the maximum number of iterations to
use.}

\item{tol}{convergence tolerance (default \code{FLT_EPSILON}).}

\item{type}{a string value specifying the norming of the hub weights.  For
\code{"normed"} scale the weights to unit length (L2 norm), and for
\code{"relative"} to unit sum.}

\item{verbose}{a logical specifying if progress and runtime information
should be displayed.}
}
\value{
A \code{numeric} vector with transaction weights for \code{data}.
}
\description{
Compute the hub transaction weights for a collection
of \link{transactions} using the HITS (hubs and authorities) algorithm.
}
\details{
Model a collection of \link{transactions} as a bipartite graph of hubs
(transactions) and authorities (items) with unit arcs and free node weights.
That is, a transaction weight is the sum of the (normalized) weights of the
items and vice versa. The weights are estimated by iterating the model to a
steady-state using a builtin convergence tolerance of \code{FLT_EPSILON} for
(the change in) the norm of the vector of authorities.
}
\examples{
data(SunBai)

## calculate transaction weigths
w <- hits(SunBai)
w

## add transaction weight to the dataset
transactionInfo(SunBai)[["weight"]] <- w
transactionInfo(SunBai)

## calulate regular item frequencies
itemFrequency(SunBai, weighted = FALSE)

## calulate weighted item frequencies
itemFrequency(SunBai, weighted = TRUE)
}
\references{
K. Sun and F. Bai (2008). Mining Weighted Association Rules
without Preassigned Weights. \emph{IEEE Transactions on Knowledge and Data
Engineering}, 4 (30), 489--495.
}
\seealso{
Other weighted association mining functions: 
\code{\link{SunBai}},
\code{\link{weclat}()}
}
\author{
Christian Buchta
}
\concept{weighted association mining functions}
\keyword{models}
