% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert_compare.R
\name{assert_between}
\alias{assert_between}
\title{Assert input is between a specified minimum and maximum value}
\usage{
assert_between(
  x,
  minimum,
  maximum,
  inclusive = TRUE,
  msg = NULL,
  call = rlang::caller_env(),
  arg_name = NULL
)
}
\arguments{
\item{x}{An object to check}

\item{minimum}{The minimum value to compare against}

\item{maximum}{The maximum value to compare against}

\item{inclusive}{should comparisons allow equality with the minimum and maximum values? (flag)}

\item{msg}{A character string containing the error message to display if \code{x} is not between the specified minimum and maximum values (string)}

\item{call}{Only relevant when pooling assertions into multi-assertion helper functions. See \link[cli]{cli_abort} for details.}

\item{arg_name}{Advanced use only. Name of the argument passed (default: NULL, will automatically extract arg_name).}
}
\value{
invisible(TRUE) if \code{x} is between the specified minimum and maximum values, otherwise aborts with the error message specified by \code{msg}
}
\description{
Assert a number is between a specified minimum and maximum value.
To check all numbers in a vector / matrix are between minimum and maximum values, see \code{\link[=assert_all_between]{assert_all_between()}}
}
\examples{
try({
assert_between(3, 1, 4) # Passes
assert_between(3, 1, 4) # Passes
assert_between(c(2,3,4), 1, 4) # Throws error (Must be a number)
assert_between('A', 1, 4) # Throws error (Must be a number)
assert_between(5, 1, 4, msg = "custom error message") # Throws custom error
})

}
\concept{assert_comparison}
