\name{astrochron-package}
\alias{astrochron-package}
\alias{astrochron}
\docType{package}
\title{astrochron: A Computational Tool for Astrochronology}
\description{
This software provides routines for astrochronologic testing, astronomical time scale 
construction, and time series analysis <doi:10.1016/j.earscirev.2018.11.015>. Also 
included are a range of statistical analysis and modeling routines that are relevant 
to time scale development and paleoclimate analysis.
}
\details{
\tabular{ll}{
Package: \tab astrochron\cr
Type: \tab Package\cr
Version: \tab 1.5\cr
Date: \tab 2025-04-28\cr
License: \tab GPL-3\cr
}
%%~~ An overview of how to use the package ~~
}
\author{
Stephen Meyers

Maintainer: Stephen Meyers <smeyers@geology.wisc.edu>
}

\note{

Development of the 'astrochron' package is partially supported by the U.S. National Science Foundation and the Heising-Simons Foundation:

\emph{Leveraging the Geologic Record to Constrain Solar System Evolution, Earth-Moon Dynamics, Paleoclimate Change and Geological Time (Heising-Simons Foundation Award 2021-2797)}

\emph{Collaborative Research: Improving the Late Cretaceous-Eocene geomagnetic polarity time scale by integrating the global magnetic anomaly record and astrochronology (U.S. National Science Foundation Award OCE 2051616)}

\emph{CAREER: Deciphering the Beat of a Timeless Rhythm - The Future of Astrochronology (U.S. National Science Foundation Award EAR 1151438)}

\emph{Collaborative Research: Evolution of the Climate Continuum - Late Paleogene to Present (U.S. National Science Foundation Award OCE 1003603)}



TO CITE THIS PACKAGE IN PUBLICATIONS, PLEASE USE:

Meyers, S.R. (2014). \emph{Astrochron: An R Package for Astrochronology}. https://cran.r-project.org/package=astrochron 

Also cite the original research papers that document the relevant algorithms, as referenced on the help pages for specific functions.

Some examples (including R scripts) demonstrating the application of the astrochron package can be found in Meyers (2019),
Ma et al. (2017), and Crampton et al. (2018), among numerous other scientific publications.  Please also see examples in the
help pages for specific functions.
}

%%~~ Optionally other standard keywords, one per line, from file KEYWORDS in the R documentation directory ~~
\keyword{ package }

\references{
J.S. Campton, S.R. Meyers, R.A. Cooper, P.M Sadler, M. Foote, D. Harte, 2018, 
\emph{Pacing of Paleozoic macroevolutionary rates by Milankovitch grand cycles}: Proceedings of the National Academy of Sciences, doi:10.1073/pnas.1714342115.

C. Ma, S.R. Meyers, B.B. Sageman, 2017
\emph{Theory of chaotic orbital variations confirmed by Cretaceous geological evidence}: Nature
v.542, 468-470, doi:10.1038/nature21402.

S.R. Meyers, 2019, 
\emph{Cyclostratigraphy and the problem of astrochronologic testing}: Earth-Science Reviews
v.190, 190-223, doi:10.1016/j.earscirev.2018.11.015.
}
