% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.r
\name{convert_http_to_at}
\alias{convert_http_to_at}
\alias{convert_at_to_http}
\title{Converts betweet http URL and AT URI}
\usage{
convert_http_to_at(link, .token = NULL)

convert_at_to_http(link)
}
\arguments{
\item{link}{either an AT or HTTP link.}

\item{.token}{If you manage your own tokens, you can supply it here. Usually
\code{NULL} is OK and will automatically load or guide you to generate a
token.}
}
\value{
either an AT or HTTP link
}
\description{
Converts betweet http URL and AT URI
}
\details{
The AT protocol uses a different scheme to link to posts, useser,
feeds etc. Instead of the common https:// link format, internally a links
starting with at:// are used (see \url{https://atproto.com/specs/at-uri-scheme}
for details). The functions convert links from the HTTP to the AT format, or
the other way around. This is useful if you want to use a link in a browser.
}
\examples{
\dontrun{
convert_http_to_at("https://bsky.app/profile/benguinaudeau.bsky.social/post/3kbi5v7oncq25")
convert_at_to_http("at://did:plc:vuvsifrusnjsys7mhkpk662u/app.bsky.feed.post/3kbi5v7oncq25")
}
}
