% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svm_classifier.R
\name{svm_classifier}
\alias{svm_classifier}
\title{SVM classifier}
\usage{
svm_classifier(
  y,
  form,
  data,
  kernel,
  type,
  probability,
  svm.gamma,
  svm.cost,
  verbose = c(TRUE, FALSE)
)
}
\arguments{
\item{y}{Outcome variable. A character vector containing the column names of
the outcome variable. A character scalar containing the column name of
the outcome variable in \code{survey}.}

\item{form}{Model formula. A two-sided linear formula describing
the model to be fit, with the outcome on the LHS and the covariates
separated by + operators on the RHS.}

\item{data}{Data. A data.frame containing the cross-validation data used to
train and evaluate the model.}

\item{kernel}{Kernel for SVM. A character string specifying the kernel to
be used for SVM. The possible types are linear, polynomial, radial, and
sigmoid. Default is radial.}

\item{type}{svm can be used as a classification machine, as a regression
  machine, or for novelty detection. Depending of whether y is a factor or
  not, the default setting for type is C-classification or eps-regression,
  respectively, but may be overwritten by setting an explicit value. Valid
  options are: #' \enumerate{
  \item C-classification
  \item nu-classification
  \item one-classification (for novelty detection)
  \item eps-regression
  \item nu-regression
}}

\item{probability}{Probability predictions. A logical argument indicating
whether the model should allow for probability predictions}

\item{svm.gamma}{Gamma parameter for SVM. This parameter is needed for all
kernels except linear.}

\item{svm.cost}{Cost parameter for SVM. This parameter specifies the cost of
constraints violation.}

\item{verbose}{Verbose output. A logical vector indicating whether or not
verbose output should be printed.}
}
\value{
The support vector machine model. An \code{\link[e1071]{svm}} object.
}
\description{
\code{svm_classifier} applies support vector machine classification to a
data set.
}
